/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.AccountAssignment;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse;

public class ListAccountAssignmentsIterable
implements SdkIterable<ListAccountAssignmentsResponse> {
    private final SsoAdminClient client;
    private final ListAccountAssignmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountAssignmentsIterable(SsoAdminClient client, ListAccountAssignmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountAssignmentsResponseFetcher();
    }

    @Override
    public Iterator<ListAccountAssignmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountAssignment> accountAssignments() {
        Function<ListAccountAssignmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountAssignments() != null) {
                return response.accountAssignments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountAssignmentsResponseFetcher
    implements SyncPageFetcher<ListAccountAssignmentsResponse> {
        private ListAccountAssignmentsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListAccountAssignmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListAccountAssignmentsResponse nextPage(ListAccountAssignmentsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAssignmentsIterable.this.client.listAccountAssignments(ListAccountAssignmentsIterable.this.firstRequest);
            }
            return ListAccountAssignmentsIterable.this.client.listAccountAssignments((ListAccountAssignmentsRequest)ListAccountAssignmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

