/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ApplicationAssignment;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsResponse;

public class ListApplicationAssignmentsIterable
implements SdkIterable<ListApplicationAssignmentsResponse> {
    private final SsoAdminClient client;
    private final ListApplicationAssignmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationAssignmentsIterable(SsoAdminClient client, ListApplicationAssignmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationAssignmentsResponseFetcher();
    }

    @Override
    public Iterator<ListApplicationAssignmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApplicationAssignment> applicationAssignments() {
        Function<ListApplicationAssignmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationAssignments() != null) {
                return response.applicationAssignments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationAssignmentsResponseFetcher
    implements SyncPageFetcher<ListApplicationAssignmentsResponse> {
        private ListApplicationAssignmentsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationAssignmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListApplicationAssignmentsResponse nextPage(ListApplicationAssignmentsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationAssignmentsIterable.this.client.listApplicationAssignments(ListApplicationAssignmentsIterable.this.firstRequest);
            }
            return ListApplicationAssignmentsIterable.this.client.listApplicationAssignments((ListApplicationAssignmentsRequest)ListApplicationAssignmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

