/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatusMetadata;

public class ListPermissionSetProvisioningStatusIterable
implements SdkIterable<ListPermissionSetProvisioningStatusResponse> {
    private final SsoAdminClient client;
    private final ListPermissionSetProvisioningStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPermissionSetProvisioningStatusIterable(SsoAdminClient client, ListPermissionSetProvisioningStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPermissionSetProvisioningStatusResponseFetcher();
    }

    @Override
    public Iterator<ListPermissionSetProvisioningStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PermissionSetProvisioningStatusMetadata> permissionSetsProvisioningStatus() {
        Function<ListPermissionSetProvisioningStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissionSetsProvisioningStatus() != null) {
                return response.permissionSetsProvisioningStatus().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListPermissionSetProvisioningStatusResponseFetcher
    implements SyncPageFetcher<ListPermissionSetProvisioningStatusResponse> {
        private ListPermissionSetProvisioningStatusResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListPermissionSetProvisioningStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListPermissionSetProvisioningStatusResponse nextPage(ListPermissionSetProvisioningStatusResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionSetProvisioningStatusIterable.this.client.listPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusIterable.this.firstRequest);
            }
            return ListPermissionSetProvisioningStatusIterable.this.client.listPermissionSetProvisioningStatus((ListPermissionSetProvisioningStatusRequest)ListPermissionSetProvisioningStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

