/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ssooidc.SsoOidcAsyncClient;
import software.amazon.awssdk.services.ssooidc.SsoOidcServiceClientConfiguration;
import software.amazon.awssdk.services.ssooidc.internal.SsoOidcServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ssooidc.model.AccessDeniedException;
import software.amazon.awssdk.services.ssooidc.model.AuthorizationPendingException;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenWithIamRequest;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenWithIamResponse;
import software.amazon.awssdk.services.ssooidc.model.ExpiredTokenException;
import software.amazon.awssdk.services.ssooidc.model.InternalServerException;
import software.amazon.awssdk.services.ssooidc.model.InvalidClientException;
import software.amazon.awssdk.services.ssooidc.model.InvalidClientMetadataException;
import software.amazon.awssdk.services.ssooidc.model.InvalidGrantException;
import software.amazon.awssdk.services.ssooidc.model.InvalidRedirectUriException;
import software.amazon.awssdk.services.ssooidc.model.InvalidRequestException;
import software.amazon.awssdk.services.ssooidc.model.InvalidRequestRegionException;
import software.amazon.awssdk.services.ssooidc.model.InvalidScopeException;
import software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest;
import software.amazon.awssdk.services.ssooidc.model.RegisterClientResponse;
import software.amazon.awssdk.services.ssooidc.model.SlowDownException;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcException;
import software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationRequest;
import software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse;
import software.amazon.awssdk.services.ssooidc.model.UnauthorizedClientException;
import software.amazon.awssdk.services.ssooidc.model.UnsupportedGrantTypeException;
import software.amazon.awssdk.services.ssooidc.transform.CreateTokenRequestMarshaller;
import software.amazon.awssdk.services.ssooidc.transform.CreateTokenWithIamRequestMarshaller;
import software.amazon.awssdk.services.ssooidc.transform.RegisterClientRequestMarshaller;
import software.amazon.awssdk.services.ssooidc.transform.StartDeviceAuthorizationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultSsoOidcAsyncClient
implements SsoOidcAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSsoOidcAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSsoOidcAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).option(SdkClientOption.API_METADATA, "SSO_OIDC#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateTokenResponse> createToken(CreateTokenRequest createTokenRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoOidcAsyncClient.resolveMetricPublishers(clientConfiguration, createTokenRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO OIDC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SlowDownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SlowDownException").httpStatusCode(400).exceptionBuilderSupplier(SlowDownException::builder).build());
                    }
                    case "InvalidRedirectUriException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRedirectUriException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRedirectUriException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(400).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "InvalidClientMetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientMetadataException").httpStatusCode(400).exceptionBuilderSupplier(InvalidClientMetadataException::builder).build());
                    }
                    case "InvalidGrantException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantException").httpStatusCode(400).exceptionBuilderSupplier(InvalidGrantException::builder).build());
                    }
                    case "UnauthorizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(400).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                    }
                    case "InvalidClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientException").httpStatusCode(401).exceptionBuilderSupplier(InvalidClientException::builder).build());
                    }
                    case "AuthorizationPendingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationPendingException").httpStatusCode(400).exceptionBuilderSupplier(AuthorizationPendingException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidScopeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidScopeException").httpStatusCode(400).exceptionBuilderSupplier(InvalidScopeException::builder).build());
                    }
                    case "UnsupportedGrantTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedGrantTypeException").httpStatusCode(400).exceptionBuilderSupplier(UnsupportedGrantTypeException::builder).build());
                    }
                    case "InvalidRequestRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestRegionException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestRegionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateTokenResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateToken").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateTokenRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateTokenWithIamResponse> createTokenWithIAM(CreateTokenWithIamRequest createTokenWithIamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createTokenWithIamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoOidcAsyncClient.resolveMetricPublishers(clientConfiguration, createTokenWithIamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO OIDC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTokenWithIAM");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTokenWithIamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SlowDownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SlowDownException").httpStatusCode(400).exceptionBuilderSupplier(SlowDownException::builder).build());
                    }
                    case "InvalidRedirectUriException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRedirectUriException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRedirectUriException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(400).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "InvalidClientMetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientMetadataException").httpStatusCode(400).exceptionBuilderSupplier(InvalidClientMetadataException::builder).build());
                    }
                    case "InvalidGrantException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantException").httpStatusCode(400).exceptionBuilderSupplier(InvalidGrantException::builder).build());
                    }
                    case "UnauthorizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(400).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                    }
                    case "InvalidClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientException").httpStatusCode(401).exceptionBuilderSupplier(InvalidClientException::builder).build());
                    }
                    case "AuthorizationPendingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationPendingException").httpStatusCode(400).exceptionBuilderSupplier(AuthorizationPendingException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidScopeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidScopeException").httpStatusCode(400).exceptionBuilderSupplier(InvalidScopeException::builder).build());
                    }
                    case "UnsupportedGrantTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedGrantTypeException").httpStatusCode(400).exceptionBuilderSupplier(UnsupportedGrantTypeException::builder).build());
                    }
                    case "InvalidRequestRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestRegionException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestRegionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateTokenWithIamResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTokenWithIAM").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateTokenWithIamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createTokenWithIamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<RegisterClientResponse> registerClient(RegisterClientRequest registerClientRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(registerClientRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoOidcAsyncClient.resolveMetricPublishers(clientConfiguration, registerClientRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO OIDC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterClient");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterClientResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SlowDownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SlowDownException").httpStatusCode(400).exceptionBuilderSupplier(SlowDownException::builder).build());
                    }
                    case "InvalidRedirectUriException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRedirectUriException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRedirectUriException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(400).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "InvalidClientMetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientMetadataException").httpStatusCode(400).exceptionBuilderSupplier(InvalidClientMetadataException::builder).build());
                    }
                    case "InvalidGrantException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantException").httpStatusCode(400).exceptionBuilderSupplier(InvalidGrantException::builder).build());
                    }
                    case "UnauthorizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(400).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                    }
                    case "InvalidClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientException").httpStatusCode(401).exceptionBuilderSupplier(InvalidClientException::builder).build());
                    }
                    case "AuthorizationPendingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationPendingException").httpStatusCode(400).exceptionBuilderSupplier(AuthorizationPendingException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidScopeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidScopeException").httpStatusCode(400).exceptionBuilderSupplier(InvalidScopeException::builder).build());
                    }
                    case "UnsupportedGrantTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedGrantTypeException").httpStatusCode(400).exceptionBuilderSupplier(UnsupportedGrantTypeException::builder).build());
                    }
                    case "InvalidRequestRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestRegionException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestRegionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<RegisterClientResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterClient").withProtocolMetadata(protocolMetadata).withMarshaller(new RegisterClientRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(registerClientRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StartDeviceAuthorizationResponse> startDeviceAuthorization(StartDeviceAuthorizationRequest startDeviceAuthorizationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(startDeviceAuthorizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoOidcAsyncClient.resolveMetricPublishers(clientConfiguration, startDeviceAuthorizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO OIDC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDeviceAuthorization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDeviceAuthorizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "SlowDownException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("SlowDownException").httpStatusCode(400).exceptionBuilderSupplier(SlowDownException::builder).build());
                    }
                    case "InvalidRedirectUriException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRedirectUriException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRedirectUriException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ExpiredTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(400).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "InvalidClientMetadataException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientMetadataException").httpStatusCode(400).exceptionBuilderSupplier(InvalidClientMetadataException::builder).build());
                    }
                    case "InvalidGrantException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidGrantException").httpStatusCode(400).exceptionBuilderSupplier(InvalidGrantException::builder).build());
                    }
                    case "UnauthorizedClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedClientException").httpStatusCode(400).exceptionBuilderSupplier(UnauthorizedClientException::builder).build());
                    }
                    case "InvalidClientException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientException").httpStatusCode(401).exceptionBuilderSupplier(InvalidClientException::builder).build());
                    }
                    case "AuthorizationPendingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationPendingException").httpStatusCode(400).exceptionBuilderSupplier(AuthorizationPendingException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidScopeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidScopeException").httpStatusCode(400).exceptionBuilderSupplier(InvalidScopeException::builder).build());
                    }
                    case "UnsupportedGrantTypeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedGrantTypeException").httpStatusCode(400).exceptionBuilderSupplier(UnsupportedGrantTypeException::builder).build());
                    }
                    case "InvalidRequestRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestRegionException").httpStatusCode(400).exceptionBuilderSupplier(InvalidRequestRegionException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<StartDeviceAuthorizationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDeviceAuthorization").withProtocolMetadata(protocolMetadata).withMarshaller(new StartDeviceAuthorizationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(startDeviceAuthorizationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final SsoOidcServiceClientConfiguration serviceClientConfiguration() {
        return new SsoOidcServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return "sso-oauth";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return ((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)builder.clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(SsoOidcException::builder)).protocol(AwsJsonProtocol.REST_JSON)).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SsoOidcServiceClientConfigurationBuilder serviceConfigBuilder = new SsoOidcServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }
}

