/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.internal;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.token.credentials.SdkToken;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class SsoOidcToken
implements SdkToken {
    public static final String PROVIDER_NAME = "SsoOidcTokenProvider";
    private final String accessToken;
    private final Instant expiresAt;
    private final String refreshToken;
    private final String clientId;
    private final String clientSecret;
    private final Instant registrationExpiresAt;
    private final String region;
    private final String startUrl;
    private final String providerName;

    private SsoOidcToken(BuilderImpl builder) {
        Validate.paramNotNull(builder.accessToken, "accessToken");
        Validate.paramNotNull(builder.expiresAt, "expiresAt");
        this.accessToken = builder.accessToken;
        this.expiresAt = builder.expiresAt;
        this.refreshToken = builder.refreshToken;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.registrationExpiresAt = builder.registrationExpiresAt;
        this.region = builder.region;
        this.startUrl = builder.startUrl;
        this.providerName = builder.providerName;
    }

    @Override
    public String token() {
        return this.accessToken;
    }

    @Override
    public Optional<Instant> expirationTime() {
        return Optional.of(this.expiresAt);
    }

    @Override
    public Optional<String> providerName() {
        return Optional.of(this.providerName);
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public Instant registrationExpiresAt() {
        return this.registrationExpiresAt;
    }

    public String region() {
        return this.region;
    }

    public String startUrl() {
        return this.startUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SsoOidcToken ssoOidcToken = (SsoOidcToken)o;
        return Objects.equals(this.accessToken, ssoOidcToken.accessToken) && Objects.equals(this.expiresAt, ssoOidcToken.expiresAt) && Objects.equals(this.refreshToken, ssoOidcToken.refreshToken) && Objects.equals(this.clientId, ssoOidcToken.clientId) && Objects.equals(this.clientSecret, ssoOidcToken.clientSecret) && Objects.equals(this.registrationExpiresAt, ssoOidcToken.registrationExpiresAt) && Objects.equals(this.region, ssoOidcToken.region) && Objects.equals(this.startUrl, ssoOidcToken.startUrl);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.accessToken);
        result = 31 * result + Objects.hashCode(this.expiresAt);
        result = 31 * result + Objects.hashCode(this.refreshToken);
        result = 31 * result + Objects.hashCode(this.clientId);
        result = 31 * result + Objects.hashCode(this.clientSecret);
        result = 31 * result + Objects.hashCode(this.registrationExpiresAt);
        result = 31 * result + Objects.hashCode(this.region);
        result = 31 * result + Objects.hashCode(this.startUrl);
        return result;
    }

    public String toString() {
        return ToString.builder("SsoOidcToken").add("accessToken", this.accessToken).add("expiresAt", this.expiresAt).add("refreshToken", this.refreshToken).add("clientId", this.clientId).add("clientSecret", this.clientSecret).add("registrationExpiresAt", this.registrationExpiresAt).add("region", this.region).add("startUrl", this.startUrl).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static class BuilderImpl
    implements Builder {
        private String accessToken;
        private Instant expiresAt;
        private String refreshToken;
        private String clientId;
        private String clientSecret;
        private Instant registrationExpiresAt;
        private String region;
        private String startUrl;
        private String providerName;

        private BuilderImpl() {
        }

        @Override
        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @Override
        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @Override
        public Builder registrationExpiresAt(Instant registrationExpiresAt) {
            this.registrationExpiresAt = registrationExpiresAt;
            return this;
        }

        @Override
        public Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder startUrl(String startUrl) {
            this.startUrl = startUrl;
            return this;
        }

        @Override
        public Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        @Override
        public SsoOidcToken build() {
            return new SsoOidcToken(this);
        }
    }

    public static interface Builder {
        public Builder accessToken(String var1);

        public Builder expiresAt(Instant var1);

        public Builder refreshToken(String var1);

        public Builder clientId(String var1);

        public Builder clientSecret(String var1);

        public Builder registrationExpiresAt(Instant var1);

        public Builder region(String var1);

        public Builder startUrl(String var1);

        public Builder providerName(String var1);

        public SsoOidcToken build();
    }
}

