/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssooidc.model.ScopesCopier;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTokenWithIamRequest
extends SsoOidcRequest
implements ToCopyableBuilder<Builder, CreateTokenWithIamRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("clientId").getter(CreateTokenWithIamRequest.getter(CreateTokenWithIamRequest::clientId)).setter(CreateTokenWithIamRequest.setter(Builder::clientId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();
    private static final SdkField<String> GRANT_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("grantType").getter(CreateTokenWithIamRequest.getter(CreateTokenWithIamRequest::grantType)).setter(CreateTokenWithIamRequest.setter(Builder::grantType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantType").build()).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("code").getter(CreateTokenWithIamRequest.getter(CreateTokenWithIamRequest::code)).setter(CreateTokenWithIamRequest.setter(Builder::code)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("refreshToken").getter(CreateTokenWithIamRequest.getter(CreateTokenWithIamRequest::refreshToken)).setter(CreateTokenWithIamRequest.setter(Builder::refreshToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()).build();
    private static final SdkField<String> ASSERTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("assertion").getter(CreateTokenWithIamRequest.getter(CreateTokenWithIamRequest::assertion)).setter(CreateTokenWithIamRequest.setter(Builder::assertion)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assertion").build()).build();
    private static final SdkField<List<String>> SCOPE_FIELD = SdkField.builder(MarshallingType.LIST).memberName("scope").getter(CreateTokenWithIamRequest.getter(CreateTokenWithIamRequest::scope)).setter(CreateTokenWithIamRequest.setter(Builder::scope)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.builder(MarshallingType.STRING).memberName("redirectUri").getter(CreateTokenWithIamRequest.getter(CreateTokenWithIamRequest::redirectUri)).setter(CreateTokenWithIamRequest.setter(Builder::redirectUri)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUri").build()).build();
    private static final SdkField<String> SUBJECT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("subjectToken").getter(CreateTokenWithIamRequest.getter(CreateTokenWithIamRequest::subjectToken)).setter(CreateTokenWithIamRequest.setter(Builder::subjectToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectToken").build()).build();
    private static final SdkField<String> SUBJECT_TOKEN_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("subjectTokenType").getter(CreateTokenWithIamRequest.getter(CreateTokenWithIamRequest::subjectTokenType)).setter(CreateTokenWithIamRequest.setter(Builder::subjectTokenType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectTokenType").build()).build();
    private static final SdkField<String> REQUESTED_TOKEN_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("requestedTokenType").getter(CreateTokenWithIamRequest.getter(CreateTokenWithIamRequest::requestedTokenType)).setter(CreateTokenWithIamRequest.setter(Builder::requestedTokenType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedTokenType").build()).build();
    private static final SdkField<String> CODE_VERIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("codeVerifier").getter(CreateTokenWithIamRequest.getter(CreateTokenWithIamRequest::codeVerifier)).setter(CreateTokenWithIamRequest.setter(Builder::codeVerifier)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeVerifier").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, GRANT_TYPE_FIELD, CODE_FIELD, REFRESH_TOKEN_FIELD, ASSERTION_FIELD, SCOPE_FIELD, REDIRECT_URI_FIELD, SUBJECT_TOKEN_FIELD, SUBJECT_TOKEN_TYPE_FIELD, REQUESTED_TOKEN_TYPE_FIELD, CODE_VERIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTokenWithIamRequest.memberNameToFieldInitializer();
    private final String clientId;
    private final String grantType;
    private final String code;
    private final String refreshToken;
    private final String assertion;
    private final List<String> scope;
    private final String redirectUri;
    private final String subjectToken;
    private final String subjectTokenType;
    private final String requestedTokenType;
    private final String codeVerifier;

    private CreateTokenWithIamRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.grantType = builder.grantType;
        this.code = builder.code;
        this.refreshToken = builder.refreshToken;
        this.assertion = builder.assertion;
        this.scope = builder.scope;
        this.redirectUri = builder.redirectUri;
        this.subjectToken = builder.subjectToken;
        this.subjectTokenType = builder.subjectTokenType;
        this.requestedTokenType = builder.requestedTokenType;
        this.codeVerifier = builder.codeVerifier;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String grantType() {
        return this.grantType;
    }

    public final String code() {
        return this.code;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final String assertion() {
        return this.assertion;
    }

    public final boolean hasScope() {
        return this.scope != null && !(this.scope instanceof SdkAutoConstructList);
    }

    public final List<String> scope() {
        return this.scope;
    }

    public final String redirectUri() {
        return this.redirectUri;
    }

    public final String subjectToken() {
        return this.subjectToken;
    }

    public final String subjectTokenType() {
        return this.subjectTokenType;
    }

    public final String requestedTokenType() {
        return this.requestedTokenType;
    }

    public final String codeVerifier() {
        return this.codeVerifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantType());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.assertion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScope() ? this.scope() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectTokenType());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedTokenType());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeVerifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenWithIamRequest)) {
            return false;
        }
        CreateTokenWithIamRequest other = (CreateTokenWithIamRequest)obj;
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.grantType(), other.grantType()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.assertion(), other.assertion()) && this.hasScope() == other.hasScope() && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.redirectUri(), other.redirectUri()) && Objects.equals(this.subjectToken(), other.subjectToken()) && Objects.equals(this.subjectTokenType(), other.subjectTokenType()) && Objects.equals(this.requestedTokenType(), other.requestedTokenType()) && Objects.equals(this.codeVerifier(), other.codeVerifier());
    }

    public final String toString() {
        return ToString.builder("CreateTokenWithIamRequest").add("ClientId", this.clientId()).add("GrantType", this.grantType()).add("Code", this.code()).add("RefreshToken", this.refreshToken() == null ? null : "*** Sensitive Data Redacted ***").add("Assertion", this.assertion() == null ? null : "*** Sensitive Data Redacted ***").add("Scope", this.hasScope() ? this.scope() : null).add("RedirectUri", this.redirectUri()).add("SubjectToken", this.subjectToken() == null ? null : "*** Sensitive Data Redacted ***").add("SubjectTokenType", this.subjectTokenType()).add("RequestedTokenType", this.requestedTokenType()).add("CodeVerifier", this.codeVerifier() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "grantType": {
                return Optional.ofNullable(clazz.cast(this.grantType()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "refreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "assertion": {
                return Optional.ofNullable(clazz.cast(this.assertion()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "redirectUri": {
                return Optional.ofNullable(clazz.cast(this.redirectUri()));
            }
            case "subjectToken": {
                return Optional.ofNullable(clazz.cast(this.subjectToken()));
            }
            case "subjectTokenType": {
                return Optional.ofNullable(clazz.cast(this.subjectTokenType()));
            }
            case "requestedTokenType": {
                return Optional.ofNullable(clazz.cast(this.requestedTokenType()));
            }
            case "codeVerifier": {
                return Optional.ofNullable(clazz.cast(this.codeVerifier()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("grantType", GRANT_TYPE_FIELD);
        map.put("code", CODE_FIELD);
        map.put("refreshToken", REFRESH_TOKEN_FIELD);
        map.put("assertion", ASSERTION_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("redirectUri", REDIRECT_URI_FIELD);
        map.put("subjectToken", SUBJECT_TOKEN_FIELD);
        map.put("subjectTokenType", SUBJECT_TOKEN_TYPE_FIELD);
        map.put("requestedTokenType", REQUESTED_TOKEN_TYPE_FIELD);
        map.put("codeVerifier", CODE_VERIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenWithIamRequest, T> g) {
        return obj -> g.apply((CreateTokenWithIamRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoOidcRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private String grantType;
        private String code;
        private String refreshToken;
        private String assertion;
        private List<String> scope = DefaultSdkAutoConstructList.getInstance();
        private String redirectUri;
        private String subjectToken;
        private String subjectTokenType;
        private String requestedTokenType;
        private String codeVerifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenWithIamRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.grantType(model.grantType);
            this.code(model.code);
            this.refreshToken(model.refreshToken);
            this.assertion(model.assertion);
            this.scope(model.scope);
            this.redirectUri(model.redirectUri);
            this.subjectToken(model.subjectToken);
            this.subjectTokenType(model.subjectTokenType);
            this.requestedTokenType(model.requestedTokenType);
            this.codeVerifier(model.codeVerifier);
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getGrantType() {
            return this.grantType;
        }

        public final void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @Override
        public final Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getAssertion() {
            return this.assertion;
        }

        public final void setAssertion(String assertion) {
            this.assertion = assertion;
        }

        @Override
        public final Builder assertion(String assertion) {
            this.assertion = assertion;
            return this;
        }

        public final Collection<String> getScope() {
            if (this.scope instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scope;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
        }

        @Override
        public final Builder scope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(String ... scope) {
            this.scope(Arrays.asList(scope));
            return this;
        }

        public final String getRedirectUri() {
            return this.redirectUri;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public final String getSubjectToken() {
            return this.subjectToken;
        }

        public final void setSubjectToken(String subjectToken) {
            this.subjectToken = subjectToken;
        }

        @Override
        public final Builder subjectToken(String subjectToken) {
            this.subjectToken = subjectToken;
            return this;
        }

        public final String getSubjectTokenType() {
            return this.subjectTokenType;
        }

        public final void setSubjectTokenType(String subjectTokenType) {
            this.subjectTokenType = subjectTokenType;
        }

        @Override
        public final Builder subjectTokenType(String subjectTokenType) {
            this.subjectTokenType = subjectTokenType;
            return this;
        }

        public final String getRequestedTokenType() {
            return this.requestedTokenType;
        }

        public final void setRequestedTokenType(String requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
        }

        @Override
        public final Builder requestedTokenType(String requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
            return this;
        }

        public final String getCodeVerifier() {
            return this.codeVerifier;
        }

        public final void setCodeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
        }

        @Override
        public final Builder codeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTokenWithIamRequest build() {
            return new CreateTokenWithIamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoOidcRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTokenWithIamRequest> {
        public Builder clientId(String var1);

        public Builder grantType(String var1);

        public Builder code(String var1);

        public Builder refreshToken(String var1);

        public Builder assertion(String var1);

        public Builder scope(Collection<String> var1);

        public Builder scope(String ... var1);

        public Builder redirectUri(String var1);

        public Builder subjectToken(String var1);

        public Builder subjectTokenType(String var1);

        public Builder requestedTokenType(String var1);

        public Builder codeVerifier(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

