/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.internal.StsAuthUtils;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@ThreadSafe
public class StsGetSessionTokenCredentialsProvider
extends StsCredentialsProvider
implements ToCopyableBuilder<Builder, StsGetSessionTokenCredentialsProvider> {
    private static final String PROVIDER_NAME = "StsGetSessionTokenCredentialsProvider";
    private final GetSessionTokenRequest getSessionTokenRequest;

    private StsGetSessionTokenCredentialsProvider(Builder builder) {
        super(builder, "sts-get-token-credentials-provider");
        Validate.notNull(builder.getSessionTokenRequest, "Get session token request must not be null.", new Object[0]);
        this.getSessionTokenRequest = builder.getSessionTokenRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected AwsSessionCredentials getUpdatedCredentials(StsClient stsClient) {
        GetSessionTokenResponse sessionToken = stsClient.getSessionToken(this.getSessionTokenRequest);
        return StsAuthUtils.fromStsCredentials(sessionToken.credentials(), PROVIDER_NAME);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    String providerName() {
        return PROVIDER_NAME;
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsGetSessionTokenCredentialsProvider> {
        private GetSessionTokenRequest getSessionTokenRequest = (GetSessionTokenRequest)GetSessionTokenRequest.builder().build();

        private Builder() {
            super((B x$0) -> new StsGetSessionTokenCredentialsProvider((Builder)x$0));
        }

        public Builder(StsGetSessionTokenCredentialsProvider provider) {
            super(x$0 -> new StsGetSessionTokenCredentialsProvider((Builder)x$0), provider);
            this.getSessionTokenRequest = provider.getSessionTokenRequest;
        }

        public Builder refreshRequest(GetSessionTokenRequest getSessionTokenRequest) {
            this.getSessionTokenRequest = getSessionTokenRequest;
            return this;
        }

        public Builder refreshRequest(Consumer<GetSessionTokenRequest.Builder> getFederationTokenRequest) {
            return this.refreshRequest((GetSessionTokenRequest)GetSessionTokenRequest.builder().applyMutation(getFederationTokenRequest).build());
        }

        @Override
        public StsGetSessionTokenCredentialsProvider build() {
            return (StsGetSessionTokenCredentialsProvider)super.build();
        }
    }
}

