/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.sts.auth.scheme.StsAuthSchemeParams;
import software.amazon.awssdk.services.sts.auth.scheme.StsAuthSchemeProvider;

@SdkInternalApi
public final class DefaultStsAuthSchemeProvider
implements StsAuthSchemeProvider {
    private static final DefaultStsAuthSchemeProvider DEFAULT = new DefaultStsAuthSchemeProvider();

    private DefaultStsAuthSchemeProvider() {
    }

    public static DefaultStsAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(StsAuthSchemeParams params) {
        ArrayList<AuthSchemeOption> options = new ArrayList<AuthSchemeOption>();
        switch (params.operation()) {
            case "AssumeRoleWithSAML": 
            case "AssumeRoleWithWebIdentity": {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("smithy.api#noAuth").build());
                break;
            }
            default: {
                options.add((AuthSchemeOption)AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, "sts").putSignerProperty(AwsV4HttpSigner.REGION_NAME, params.region().id()).build());
            }
        }
        return Collections.unmodifiableList(options);
    }
}

