/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.lz4;

import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4Compressor;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4Native;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;

public final class Lz4NativeCompressor
implements Lz4Compressor {
    private final MemorySegment state = Arena.ofAuto().allocate(Lz4Native.STATE_SIZE);
    private final int acceleration;

    public Lz4NativeCompressor() {
        this(1);
    }

    public Lz4NativeCompressor(int acceleration) {
        if (acceleration < 1 || acceleration > 65537) {
            throw new IllegalArgumentException("LZ4 acceleration should be in the [%d, %d] range but got %d".formatted(1, 65537, acceleration));
        }
        Lz4Native.verifyEnabled();
        this.acceleration = acceleration;
    }

    public static boolean isEnabled() {
        return Lz4Native.isEnabled();
    }

    @Override
    public int maxCompressedLength(int uncompressedSize) {
        return Lz4Native.maxCompressedLength(uncompressedSize);
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        MemorySegment inputSegment = MemorySegment.ofArray(input).asSlice((long)inputOffset, inputLength);
        MemorySegment outputSegment = MemorySegment.ofArray(output).asSlice((long)outputOffset, maxOutputLength);
        return Lz4Native.compress(inputSegment, inputLength, outputSegment, maxOutputLength, this.acceleration, this.state);
    }

    @Override
    public int compress(MemorySegment input, MemorySegment output) {
        return Lz4Native.compress(input, Math.toIntExact(input.byteSize()), output, Math.toIntExact(output.byteSize()), this.acceleration, this.state);
    }
}

