/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.snappy;

import io.trino.jdbc.$internal.airlift.compress.v3.hadoop.HadoopInputStream;
import io.trino.jdbc.$internal.airlift.compress.v3.hadoop.HadoopOutputStream;
import io.trino.jdbc.$internal.airlift.compress.v3.hadoop.HadoopStreams;
import io.trino.jdbc.$internal.airlift.compress.v3.snappy.SnappyCompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.snappy.SnappyDecompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.snappy.SnappyHadoopInputStream;
import io.trino.jdbc.$internal.airlift.compress.v3.snappy.SnappyHadoopOutputStream;
import io.trino.jdbc.$internal.airlift.compress.v3.snappy.SnappyJavaCompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.snappy.SnappyJavaDecompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.snappy.SnappyNative;
import io.trino.jdbc.$internal.airlift.compress.v3.snappy.SnappyNativeCompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.snappy.SnappyNativeDecompressor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

public class SnappyHadoopStreams
implements HadoopStreams {
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 262144;
    private final boolean useNative;
    private final int bufferSize;

    public SnappyHadoopStreams() {
        this(true, 262144);
    }

    public SnappyHadoopStreams(boolean useNative, int bufferSize) {
        this.useNative = useNative && SnappyNative.isEnabled();
        this.bufferSize = bufferSize;
    }

    @Override
    public String getDefaultFileExtension() {
        return ".snappy";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("org.apache.hadoop.io.compress.SnappyCodec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) {
        SnappyDecompressor decompressor = this.useNative ? new SnappyNativeDecompressor() : new SnappyJavaDecompressor();
        return new SnappyHadoopInputStream(decompressor, in);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) {
        SnappyCompressor compressor = this.useNative ? new SnappyNativeCompressor() : new SnappyJavaCompressor();
        return new SnappyHadoopOutputStream(compressor, out, this.bufferSize);
    }
}

