/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.okhttp3.internal.http;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.kotlin.collections.CollectionsKt;
import io.trino.jdbc.$internal.kotlin.jvm.internal.Intrinsics;
import io.trino.jdbc.$internal.kotlin.text.StringsKt;
import io.trino.jdbc.$internal.okhttp3.Cookie;
import io.trino.jdbc.$internal.okhttp3.CookieJar;
import io.trino.jdbc.$internal.okhttp3.Headers;
import io.trino.jdbc.$internal.okhttp3.Interceptor;
import io.trino.jdbc.$internal.okhttp3.MediaType;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.RequestBody;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.okhttp3.ResponseBody;
import io.trino.jdbc.$internal.okhttp3.internal._UtilJvmKt;
import io.trino.jdbc.$internal.okhttp3.internal.http.HttpHeaders;
import io.trino.jdbc.$internal.okhttp3.internal.http.RealResponseBody;
import io.trino.jdbc.$internal.okio.GzipSource;
import io.trino.jdbc.$internal.okio.Okio;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/trino/jdbc/$internal/okhttp3/internal/http/BridgeInterceptor;", "Lio/trino/jdbc/$internal/okhttp3/Interceptor;", "cookieJar", "Lio/trino/jdbc/$internal/okhttp3/CookieJar;", "<init>", "(Lokhttp3/CookieJar;)V", "intercept", "Lio/trino/jdbc/$internal/okhttp3/Response;", "chain", "Lio/trino/jdbc/$internal/okhttp3/Interceptor$Chain;", "cookieHeader", "", "cookies", "", "Lio/trino/jdbc/$internal/okhttp3/Cookie;", "okhttp"})
@.SourceDebugExtension(value={"SMAP\nBridgeInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeInterceptor.kt\nokhttp3/internal/http/BridgeInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1878#2,3:126\n*S KotlinDebug\n*F\n+ 1 BridgeInterceptor.kt\nokhttp3/internal/http/BridgeInterceptor\n*L\n119#1:126,3\n*E\n"})
public final class BridgeInterceptor
implements Interceptor {
    @NotNull
    private final CookieJar cookieJar;

    public BridgeInterceptor(@NotNull CookieJar cookieJar) {
        Intrinsics.checkNotNullParameter(cookieJar, "cookieJar");
        this.cookieJar = cookieJar;
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        ResponseBody responseBody;
        List<Cookie> cookies;
        Intrinsics.checkNotNullParameter(chain, "chain");
        Request userRequest = chain.request();
        Request.Builder requestBuilder = userRequest.newBuilder();
        RequestBody body = userRequest.body();
        if (body != null) {
            Request.Builder builder;
            long contentLength;
            MediaType contentType = body.contentType();
            if (contentType != null) {
                requestBuilder.header("Content-Type", contentType.toString());
            }
            if ((contentLength = body.contentLength()) != -1L) {
                requestBuilder.header("Content-Length", String.valueOf(contentLength));
                builder = requestBuilder.removeHeader("Transfer-Encoding");
            } else {
                requestBuilder.header("Transfer-Encoding", "chunked");
                builder = requestBuilder.removeHeader("Content-Length");
            }
        }
        if (userRequest.header("Host") == null) {
            requestBuilder.header("Host", _UtilJvmKt.toHostHeader$default(userRequest.url(), false, 1, null));
        }
        if (userRequest.header("Connection") == null) {
            requestBuilder.header("Connection", "Keep-Alive");
        }
        boolean transparentGzip = false;
        if (userRequest.header("Accept-Encoding") == null && userRequest.header("Range") == null) {
            transparentGzip = true;
            requestBuilder.header("Accept-Encoding", "gzip");
        }
        if (!((Collection)(cookies = this.cookieJar.loadForRequest(userRequest.url()))).isEmpty()) {
            requestBuilder.header("Cookie", this.cookieHeader(cookies));
        }
        if (userRequest.header("User-Agent") == null) {
            requestBuilder.header("User-Agent", "okhttp/5.2.1");
        }
        Request networkRequest = requestBuilder.build();
        Response networkResponse = chain.proceed(networkRequest);
        HttpHeaders.receiveHeaders(this.cookieJar, networkRequest.url(), networkResponse.headers());
        Response.Builder responseBuilder = networkResponse.newBuilder().request(networkRequest);
        if (transparentGzip && StringsKt.equals("gzip", Response.header$default(networkResponse, "Content-Encoding", null, 2, null), true) && HttpHeaders.promisesBody(networkResponse) && (responseBody = networkResponse.body()) != null) {
            GzipSource gzipSource = new GzipSource(responseBody.source());
            Headers strippedHeaders = networkResponse.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            responseBuilder.headers(strippedHeaders);
            String contentType = Response.header$default(networkResponse, "Content-Type", null, 2, null);
            responseBuilder.body(new RealResponseBody(contentType, -1L, Okio.buffer(gzipSource)));
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final String cookieHeader(List<Cookie> cookies) {
        StringBuilder stringBuilder;
        StringBuilder $this$cookieHeader_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = cookies;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cookie;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Cookie cookie2 = (Cookie)item$iv;
            int index = n;
            boolean bl2 = false;
            if (index > 0) {
                $this$cookieHeader_u24lambda_u240.append("; ");
            }
            $this$cookieHeader_u24lambda_u240.append(cookie.name()).append('=').append(cookie.value());
        }
        return stringBuilder.toString();
    }
}

