/* You must define on the next line the path to the library that 
   contains all the FORMATs used inside the dataset to export */
%let formatsLibrary=Sasuser.parms;

/* You must define on the next line the path to the dataset to export */
%let datasetToExport=Sasuser.newadmit2;

/* You must define on the next line the path to file that will
   contains all the labels. This last file will be used by TIM 
   to know all the labels and FORMATs used inside the exported dataset.
*/
%let outputFile="D:\My Documents_admin\My SAS Files\output.labels";

/* Here start the code - You don't have to read any further. */
proc format fmtlib cntlout=formatOut2 library= &formatsLibrary ;
run; quit;
proc contents data= &datasetToExport varnum out=formatOut1;
run; quit;
proc sql; 
  create table formatOut3 as
	select formatOut1.name as name, formatOut2.start as Start, formatOut2.end as End, 
           formatOut2.label as ModalityLabel
	from formatOut1, formatOut2
	where (formatOut1.format='$'||formatOut2.fmtname)
	order by formatOut1.name;
quit;
data formatOut4(keep=name label);
	set formatOut1;
	if (label^='');
run;
data formatOut5;
	set formatOut4 formatOut3;
	by name;
run;
PROC EXPORT DATA= formatOut5
     OUTFILE= &outputFile 
     DBMS=CSV REPLACE;
run;
proc datasets;
	delete formatOut1;
	delete formatOut2;
	delete formatOut3;
	delete formatOut4;
	delete formatOut5;
quit;
