function PLOTARBOL(el, width, height) {
  var self = this;
  var config = null;

  self.data = null;
  self.scriptembed = null;
  self.width = 0;
  self.height = 0;

  var datosj2 = {
    name: 'root',
    contents: [{
      name: 'primero'
    }]
  };

  /*
  Js para realizar la renderización y mostrar errores en ejecución
  Autor: Miguel Angel Cortes

  scriptChart = script de HTMLWidgets para arbol d3

  */
  var errorMessage = null;

  self.widgetRender = function(config){
    self.init_Data(config);
    self.init_width(width);
    self.init_height(height);

    self.create_Data();

    self.addPre(config.model);
    self.addContainerScript(config.script);
    self.addStyleSVG();
  };

  self.widgetRenderResize = function(width, height){
    self.init_width(width);
    self.init_height(height);
  };

  self.init_width = function(width){
    self.width = width;
  };

  self.init_height = function(height){
    self.height = height;
  };

  self.init_Data = function(datos){
    config = datos;
    self.data = config.data;
  };

  self.create_Data = function(){
    if(self.scriptembed == null){
      self.scriptembed = el;
    }

    var containerPlot = createSVGContainer();
    containerPlot.id = "tree-container";
    containerPlot.style.width = "100%";
    containerPlot.style.height = "100%";

    self.scriptembed.appendChild(containerPlot);
  };

  self.addPre = function(code){
    var codes = "Model formula: \n" +
    "hp ~ cyl + disp + mpg + drat + wt + qsec + vs + am + gear + carb \n" +
    "\n" +
    "Fitted party: \n" +
    "[1] root \n" +
    "|   [2] cyl < 7";

    var preadd = document.createElement("pre");
    preadd.innerHTML = code;

    document.body.appendChild(preadd);
  };

  self.addStyleSVG = function(){

    var style = ".node { \n" +
    "cursor: pointer; \n" +
    "}\n" +
    ".overlay{\n" +
        "background-color:#EEE;\n" +
    "}\n" +
    ".node circle {\n" +
      "fill: #fff;\n" +
      "stroke: steelblue;\n" +
      "stroke-width: 1.5px;\n" +
    "}\n" +
    ".node text {\n" +
      "font-size:10px; \n" +
      "font-family:sans-serif;\n" +
    "}\n" +
    ".link {\n" +
      "fill: none;\n" +
      "stroke: #ccc;\n" +
      "stroke-width: 1.5px;\n" +
    "}\n" +
    ".templink {\n" +
      "fill: none;\n" +
      "stroke: red;\n" +
      "stroke-width: 3px;\n" +
    "}\n" +
    ".ghostCircle.show{\n" +
        "display:block;\n" +
    "}\n" +
    ".ghostCircle, .activeDrag .ghostCircle{\n" +
         "display: none;\n" +
    "}";

    var styleadd = document.createElement("style");
    styleadd.innerHTML = style;

    document.head.appendChild(styleadd);
  };

  self.addContainerScript = function(script) {
    var code = document.createElement("script");
    code.type = "text/javascript";

    var debugComments = "//#debug -- Timi Plot \n";
    code.text = debugComments + script;

    document.body.appendChild(code);
  };

  var createSVGContainer = function() {
    var div = document.getElementById("tree-container");

    if(!div){
      return document.createElement("div");
    } else {
      return document.getElementById("tree-container");
    }
  };

  var scriptsCharjs = function(line){

  };

  self.scriptsCharjs_write = function(){
    var script = self.scriptChart;

    try {
      ChartScript(self.script);
    } catch (error) {
      self.myError(error);
    }
  };

  self.myError = function(message){
    errorMessage = message;
    rendermyError();
  };

  var rendermyError = function(){
    var errorMessagefunction = errorMessage;
    var containerError = document.getElementById("plot_error");

    if (!containerError){
      containerError = document.createElement("div");
      self.scriptembed.appendChild(containerError);
      containerError.id = "plot_error";
    } else {
      containerError.innerHTML = "";
    }

    var containerMessageError = document.getElementById("div-message");

    if (!containerMessageError){
      containerMessageError = document.createElement("div");
      containerError.appendChild(containerMessageError);
      containerMessageError.id = "div-message";
      containerMessageError.innerText = "Error: " + errorMessagefunction.replace("\n", "");
    } else {
      containerMessageError.innerHTML = "";
    }
  };

}
