function PLOTCHART(el, width, height) {
  var self = this;
  var config = null;

  self.data = null;
  self.scriptembed = null;
  self.width = 0;
  self.height = 0;

  /*
  Js para realizar la renderización y mostrar errores en ejecución
  Autor: Miguel Angel Cortes

  scriptChart = script de HTMLWidgets

  */
  var errorMessage = null;

  self.widgetRender = function(config){
    self.init_Data(config);
    self.init_width(width);
    self.init_height(height);

    self.create_Data();

    self.addContainerScript(config.script);
  };

  self.widgetRenderResize = function(width, height){
    self.init_width(width);
    self.init_height(height);
  };

  self.init_width = function(width){
    self.width = width;
  };

  self.init_height = function(height){
    self.height = height;
  };

  self.init_Data = function(datos){
    config = datos;
    self.data = config.data;
  };

  self.create_Data = function(){
    if(self.scriptembed == null){
      self.scriptembed = el;
    }

    var containerPlot = createCanvasContainer();
    containerPlot.id = "mychart";
    containerPlot.innerText = "Datos";

    self.scriptembed.appendChild(containerPlot);
  };

  self.addContainerScript = function(script) {
    var code = document.createElement("script");
    code.type = "text/javascript";

    var debugComments = "//#datosUrl -- Timi Plot \n";
    code.text = debugComments + script;

    document.body.appendChild(code);
  };

  var createCanvasContainer = function() {
    var canvas = document.getElementById("mychart");

    if(!canvas){
      return document.createElement("canvas");
      //canvas.id = "mychart";
    } else {
      return document.getElementById("mychart");
    }
  };

  var scriptsCharjs = function(line){

  };

  self.scriptsCharjs_write = function(){
    var script = self.scriptChart;

    try {
      ChartScript(self.script);
    } catch (error) {
      self.myError(error);
    }
  };

  self.myError = function(message){
    errorMessage = message;
    rendermyError();
  };

  var rendermyError = function(){
    var errorMessagefunction = errorMessage;
    var containerError = document.getElementById("plot_error");

    if (!containerError){
      containerError = document.createElement("div");
      self.scriptembed.appendChild(containerError);
      containerError.id = "plot_error";
    } else {
      containerError.innerHTML = "";
    }

    var containerMessageError = document.getElementById("div-message");

    if (!containerMessageError){
      containerMessageError = document.createElement("div");
      containerError.appendChild(containerMessageError);
      containerMessageError.id = "div-message";
      containerMessageError.innerText = "Error: " + errorMessagefunction.replace("\n", "");
    } else {
      containerMessageError.innerHTML = "";
    }
  };

}
